<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\Fare;
use App\Models\Zone;

class FareController extends Controller
{
    public function calculateFare(Request $request)
    {
      //  echo "hi";
    //   print_r($request->all());
    //    die();
        $origin = $request->origin;
        $destination = $request->destination;
        $waypoints= $request->waypoints ?? [];
        $vehicleType = $request->vehicle_type;

        // 1. Format waypoints string
        $waypointsStr = implode('|', $waypoints);

        // 2. Google Distance Matrix or Directions API
        $googleApiKey = Settings::pluck('google_map_api_key')->first() ;
        $response = Http::get("https://maps.googleapis.com/maps/api/directions/json", [
            'origin' => $origin,
            'destination' => $destination,
            'waypoints' => $waypointsStr,
            'key' => $googleApiKey,
        ]);

        $data = $response->json();

        if ($data['status'] !== 'OK') {
            return response()->json(['error' => 'Google Maps API failed'], 400);
        }

        // 3. Sum total distance in meters
        $totalMeters = collect($data['routes'][0]['legs'])->sum(function ($leg) {
            return $leg['distance']['value'];
        });
        $totalKm = $totalMeters / 1000;

        // 4. Get origin zone
        $originZoneId = $this->getZoneIdFromLocation($origin);
        if (!$originZoneId) {
            return response()->json(['error' => 'Origin not in any zone'], 400);
        }

        // 5. Get fare from DB
        $fare = Fare::where('vehicle_type_id', $vehicleType)
                    ->whereJsonContains('city_id', $originZoneId)
                    ->first();

        if (!$fare) {
            return response()->json(['error' => 'Fare not found'], 400);
        }

        // 6. Calculate total fare
        $excessKm = max(0, $totalKm - $fare->base_km);
        $totalFare = $fare->base_rate + ($excessKm * $fare->additional_km_rate);

        return response()->json([
            'distance_km' => round($totalKm, 2),
            'fare' => round($totalFare, 2),
        ]);
    }

    private function getZoneIdFromLocation($locationName)
    {
        // Use Google Maps Geocoding API to get lat/lng
        $geoResp = Http::get("https://maps.googleapis.com/maps/api/geocode/json", [
            'address' => $locationName,
            'key' => Settings::pluck('google_map_api_key')->first() ,
        ]);

        $geoData = $geoResp->json();

        if (empty($geoData['results'])) return null;

        $lat = $geoData['results'][0]['geometry']['location']['lat'];
        $lng = $geoData['results'][0]['geometry']['location']['lng'];

        // Check which zone contains this point (assuming Zone polygons are stored)
        foreach (Zone::all() as $zone) {
            if ($this->pointInPolygon([$lat, $lng], json_decode($zone->coordinates))) {
                return $zone->id;
            }
        }

        return null;
    }

    private function pointInPolygon($point, $polygon)
    {
        print_r($polygon);die();
        // ray-casting algorithm for point-in-polygon
        $x = $point[1];
        $y = $point[0];
        $inside = false;

        for ($i = 0, $j = count($polygon) - 1; $i < count($polygon); $j = $i++) {
            $xi = $polygon[$i][1];
            $yi = $polygon[$i][0];
            $xj = $polygon[$j][1];
            $yj = $polygon[$j][0];

            $intersect = (($yi > $y) != ($yj > $y)) &&
                         ($x < ($xj - $xi) * ($y - $yi) / ($yj - $yi + 0.000001) + $xi);

            if ($intersect) $inside = !$inside;
        }

        return $inside;
    }
}
